/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Flt   angle   ; // car wheel angle
Actor car     , // car    actor
      ground  ; // ground actor
Wheel wheel[4]; // wheels
/******************************************************************************/
void InitPre()
{
   App.name="Vehicle";
   App.flag=APP_FULL_TOGGLE|APP_NO_FX;
   PakAdd("../data/engine.pak");

   D.mode(800,600).sync(true);
   ViewportFull.range=200;
}
Bool Init()
{
   Cam.dist=10;
   Physics.create();
   ground .create(Box_U(100,1,100),0);
   ground .pos   (ground.pos()-Vec(0,3,0));

   // create car
   car.create    (Box(2,1,4));                    // create actor
   car.massCenter(car.massCenter()-Vec(0,1.0,0)); // lower mass center

   // create car wheels
   Wheel::Param wp; // wheel parameters
   wheel[0].create(car,Vec( 1,-0.5, 1.5),wp);
   wheel[1].create(car,Vec(-1,-0.5, 1.5),wp);
   wheel[2].create(car,Vec( 1,-0.5,-1.5),wp);
   wheel[3].create(car,Vec(-1,-0.5,-1.5),wp);

   return true;
}
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1f,200,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   Physics.sim().get();

   if(Kb.bp(KB_ENTER))car.pos(Vec(0,3,0)); // reset car position on ENTER key

   // adjust car controls
   {
      angle=LerpTime(angle,(Kb.b(KB_D)-Kb.b(KB_A))*PI_4,0.01); // adjust wheel angle

      Flt accel=(Kb.b(KB_W)-Kb.b(KB_S))*1600, // acceleration
          brake= Kb.b(KB_SPACE)        *3200; // brakes

      wheel[0].angle(angle);              // set angle
      wheel[1].angle(angle);              // set angle
      wheel[2].accel(accel).brake(brake); // set acceleration and brakes
      wheel[3].accel(accel).brake(brake); // set acceleration and brakes
   }

   // update wheels
   REPAO(wheel).update();

   return true;
}
void Draw()
{
   D      .clear();
   Physics.draw ();

   (car.massCenter()*car.matrix()).draw(RED); // draw mass center
}
/******************************************************************************/
